/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBTabela;
import fme.CHTabela;
import fme.CMsgInfo;
import fme.fmeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class JTable_Tip
extends JTable {
    protected static Color cinza1 = new Color(233, 231, 227);
    protected static Color cinza2 = new Color(215, 211, 204);
    protected static Color borderColor = new Color(97, 113, 126);
    protected static Border topLeftBorder = BorderFactory.createMatteBorder(1, 1, 0, 0, borderColor);
    protected static Border leftBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, borderColor);
    protected static Border topBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor);
    public static final int EXCEL_FILE = 1;
    public static final int EXCEL_COPY = 2;
    public static final int EXCEL_PASTE = 4;
    public static final int EXCEL_CLIP = 6;
    public static final int EXCEL_HELP = 8;
    public static final int EXCEL_READ = 1;
    public static final int EXCEL_DFT = 15;
    private static final ImageIcon x_icon = new ImageIcon(fmeFrame.class.getResource("table_excel.png"));
    private static final ImageIcon b_icon = new ImageIcon(fmeFrame.class.getResource("book_excel.png"));
    private static final ImageIcon c_icon = new ImageIcon(fmeFrame.class.getResource("copy.png"));
    private static final ImageIcon p_icon = new ImageIcon(fmeFrame.class.getResource("paste.png"));
    private static final ImageIcon p2_icon = new ImageIcon(fmeFrame.class.getResource("paste2.png"));
    private static final ImageIcon h_icon = new ImageIcon(fmeFrame.class.getResource("help.png"));
    private static final ImageIcon w_icon = new ImageIcon(fmeFrame.class.getResource("wait.gif"));

    public JTable_Tip() {
        int w = this.getTableHeader().getPreferredSize().width;
        this.getTableHeader().setPreferredSize(new Dimension(w, 25));
        this.getTableHeader().setFont(fmeFrame.letra);
    }

    public JTable_Tip(int altura) {
        int w = this.getTableHeader().getPreferredSize().width;
        this.getTableHeader().setPreferredSize(new Dimension(w, altura));
        this.getTableHeader().setFont(fmeFrame.letra);
    }

    public JTable_Tip(int altura, int largura) {
        this.getTableHeader().setPreferredSize(new Dimension(5000, altura));
        this.getTableHeader().setFont(fmeFrame.letra);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            Object v = this.getValueAt(rowIndex, vColIndex);
            jc.setToolTipText(v != null && v.toString().length() > 0 && !(v instanceof Boolean) ? v.toString() : null);
            jc.setForeground(this.getForeground());
            jc.setBorder(fmeFrame.inset);
            if (rowIndex == this.getEditingRow() && vColIndex == this.getEditingColumn()) {
                jc.setBackground(this.getBackground());
            } else if (this.isCellSelected(rowIndex, vColIndex) && this.isEnabled()) {
                jc.setBackground(fmeFrame.rosa_cinza);
            } else if (this.isCellEditable(rowIndex, vColIndex)) {
                jc.setBackground(this.getBackground());
            } else {
                jc.setBackground(this.cinza(rowIndex));
            }
        }
        return c;
    }

    protected Color cinza(int rowIndex) {
        return cinza1;
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.isEditing() && (rowIndex != this.getEditingRow() || columnIndex != this.getEditingColumn())) {
            return;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (this.editCellAt(rowIndex, columnIndex)) {
            this.getEditorComponent().requestFocusInWindow();
        }
        if (this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        this.editCellAt(rowIndex, columnIndex);
    }

    public ExcelButton addExcelButton(JPanel jp, int left, int top) {
        return this.addExcelButton(jp, left, top, 15);
    }

    public ExcelButton addExcelButton(JPanel jp, int left, int top, int sel) {
        if ((sel & 7) == 0) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                if ((sel & 6) != 0) {
                    sm.checkSystemClipboardAccess();
                }
                if ((sel & 1) != 0) {
                    sm.checkWrite("<<ALL FILES>>");
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        ExcelButton jb = new ExcelButton(sel);
        jb.setBorder(BorderFactory.createEtchedBorder());
        jb.setBounds(left, top, 26, 20);
        jb.setDisabledIcon(w_icon);
        jb.setIcon(x_icon);
        jp.add(jb);
        return jb;
    }

    public CBTabela getCBTabela() {
        return this.getModel() instanceof CHTabela ? ((CHTabela)this.getModel()).d : null;
    }

    class ExcelButton
    extends JButton {
        JPopupMenu popup;
        JMenuItem export;
        JMenuItem copiar;
        JMenuItem colar;
        JMenuItem colar2;
        JMenuItem ajuda;

        ExcelButton() {
            this(15);
        }

        ExcelButton(int sel) {
            final ExcelButton face = this;
            this.popup = new JPopupMenu();
            this.setToolTipText("Clique para ver a lista de op\u00e7\u00f5es");
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!face.isEnabled()) {
                        return;
                    }
                    ExcelButton.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            });
            if ((sel & 1) != 0) {
                this.export = new JMenuItem("Exportar o Quadro completo para Excel", b_icon);
                this.export.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CBTabela cbt = JTable_Tip.this.getCBTabela();
                        if (cbt != null) {
                            cbt.on_excel_file(face);
                        }
                    }
                });
                this.export.setFont(fmeFrame.letra);
                this.popup.add(this.export);
            }
            if ((sel & 2) != 0) {
                this.copiar = new JMenuItem("Copiar o Quadro completo para o Clipboard", c_icon);
                this.copiar.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CBTabela cbt = JTable_Tip.this.getCBTabela();
                        if (cbt != null) {
                            cbt.on_copy_data();
                        }
                    }
                });
                this.copiar.setFont(fmeFrame.letra);
                this.popup.add(this.copiar);
            }
            if ((sel & 4) != 0) {
                this.colar = new JMenuItem("Colar o Quadro completo do Clipboard", p_icon);
                this.colar.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CBTabela cbt = JTable_Tip.this.getCBTabela();
                        if (cbt != null) {
                            cbt.on_paste_data();
                        }
                    }
                });
                this.colar.setFont(fmeFrame.letra);
                this.popup.add(this.colar);
                this.colar2 = new JMenuItem("Colar parte do Quadro do Clipboard", p2_icon);
                this.colar2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CBTabela cbt = JTable_Tip.this.getCBTabela();
                        if (cbt != null) {
                            cbt.on_paste_data2();
                        }
                    }
                });
                this.colar2.setFont(fmeFrame.letra);
                this.popup.add(this.colar2);
            }
            if ((sel & 8) != 0) {
                this.popup.add(new JSeparator());
                this.ajuda = new JMenuItem("Ajuda", h_icon);
                this.ajuda.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        new CMsgInfo("ajuda_xls.html", 550, 450);
                    }
                });
                this.ajuda.setFont(fmeFrame.letra);
                this.popup.add(this.ajuda);
            }
        }

        boolean setReadOnly(boolean b) {
            JMenuItem ro = this.export;
            if (ro == null) {
                return false;
            }
            Component[] componentArray = this.popup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp != ro) {
                    comp.setVisible(!b);
                }
                ++n2;
            }
            return true;
        }
    }
}

